/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import tiled.core.MapLayer;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.mapeditor.MapEditor;
import tiled.mapeditor.Resources;
import tiled.mapeditor.selection.SelectionLayer;
import tiled.mapeditor.util.PropertiesTableModel;
import tiled.mapeditor.widget.VerticalStaticJPanel;

public class TileInstancePropertiesDialog
extends JDialog
implements TableModelListener {
    private JTable propertiesTable;
    private PropertiesTableModel tableModel = new PropertiesTableModel();
    private static final String DIALOG_TITLE = "Tile Properties";
    private static final String APPLY_BUTTON = Resources.getString("general.button.apply");
    private static final String APPLY_TOOLTIP = "Apply properties to selected tiles";
    private static final String DELETE_BUTTON = Resources.getString("general.button.delete");
    private final MapEditor editor;
    private final LinkedList<Point> propertiesCoordinates = new LinkedList();
    private final Properties mergedProperties = new Properties();

    public TileInstancePropertiesDialog(MapEditor editor) {
        super(editor.getAppFrame(), DIALOG_TITLE, false);
        this.editor = editor;
        this.tableModel.addTableModelListener(this);
        this.init();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private Properties getPropertiesAt(Point p) {
        MapLayer ml = this.editor.getCurrentLayer();
        if (!(ml instanceof TileLayer)) {
            return null;
        }
        return ((TileLayer)ml).getTileInstancePropertiesAt(p.x, p.y);
    }

    private void setPropertiesAt(Point point, Properties properties) {
        MapLayer ml = this.editor.getCurrentLayer();
        if (!(ml instanceof TileLayer)) {
            return;
        }
        ((TileLayer)ml).setTileInstancePropertiesAt(point.x, point.y, properties);
    }

    private void init() {
        this.propertiesTable = new JTable(this.tableModel);
        JScrollPane propScrollPane = new JScrollPane(this.propertiesTable);
        propScrollPane.setPreferredSize(new Dimension(200, 150));
        JButton applyButton = new JButton(APPLY_BUTTON);
        applyButton.setToolTipText(APPLY_TOOLTIP);
        JButton deleteButton = new JButton(Resources.getIcon("gnome-delete.png"));
        deleteButton.setToolTipText(DELETE_BUTTON);
        VerticalStaticJPanel user = new VerticalStaticJPanel();
        user.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        user.setLayout(new BoxLayout(user, 0));
        user.add(Box.createGlue());
        user.add(Box.createRigidArea(new Dimension(5, 0)));
        user.add(deleteButton);
        VerticalStaticJPanel buttons = new VerticalStaticJPanel();
        buttons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(Box.createGlue());
        buttons.add(applyButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(propScrollPane);
        mainPanel.add(user);
        mainPanel.add(buttons);
        this.getContentPane().add(mainPanel);
        this.getRootPane().setDefaultButton(applyButton);
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TileInstancePropertiesDialog.this.buildPropertiesAndApply();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TileInstancePropertiesDialog.this.deleteSelected();
            }
        });
    }

    public void setSelection(SelectionLayer selection) {
        this.mergedProperties.clear();
        this.propertiesCoordinates.clear();
        MapLayer ml = this.editor.getCurrentLayer();
        if (ml instanceof TileLayer) {
            TileLayer tl = (TileLayer)ml;
            Rectangle r = selection.getSelectedAreaBounds();
            int maxJ = (int)(r.getY() + r.getHeight());
            int maxI = (int)(r.getX() + r.getWidth());
            for (int j = (int)r.getY(); j < maxJ; ++j) {
                for (int i = (int)r.getX(); i < maxI; ++i) {
                    Tile t = selection.getTileAt(i, j);
                    if (t == null) continue;
                    this.propertiesCoordinates.add(new Point(i, j));
                }
            }
            if (!this.propertiesCoordinates.isEmpty()) {
                Point point = this.propertiesCoordinates.get(0);
                Properties p = tl.getTileInstancePropertiesAt(point.x, point.y);
                if (p != null) {
                    this.mergedProperties.putAll((Map<?, ?>)p);
                    for (int i = 1; i < this.propertiesCoordinates.size(); ++i) {
                        point = this.propertiesCoordinates.get(i);
                        p = tl.getTileInstancePropertiesAt(point.x, point.y);
                        if (p != null) {
                            Enumeration<Object> e = this.mergedProperties.keys();
                            while (e.hasMoreElements()) {
                                String key = (String)e.nextElement();
                                String val = this.mergedProperties.getProperty(key);
                                String mval = p.getProperty(key);
                                if (mval == null) {
                                    this.mergedProperties.remove(key);
                                    continue;
                                }
                                if (mval.equals(val)) continue;
                                this.mergedProperties.setProperty(key, "?");
                            }
                            continue;
                        }
                        this.mergedProperties.clear();
                        break;
                    }
                }
            }
        }
        this.tableModel.setProperties(this.mergedProperties);
    }

    private void buildPropertiesAndApply() {
        TableCellEditor cellEditor = this.propertiesTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        this.applyPropertiesToTiles();
    }

    private void deleteFromSelectedTiles(String key) {
        for (Point point : this.propertiesCoordinates) {
            Properties p = this.getPropertiesAt(point);
            if (p == null) continue;
            p.remove(key);
        }
    }

    private void deleteSelected() {
        int i;
        int total = this.propertiesTable.getSelectedRowCount();
        Object[] keys = new Object[total];
        int[] selRows = this.propertiesTable.getSelectedRows();
        for (i = 0; i < total; ++i) {
            keys[i] = this.propertiesTable.getValueAt(selRows[i], 0);
        }
        for (i = 0; i < total; ++i) {
            if (keys[i] == null) continue;
            this.tableModel.remove(keys[i]);
            this.deleteFromSelectedTiles((String)keys[i]);
        }
    }

    private void applyPropertiesToTiles() {
        String val;
        String key;
        Enumeration<Object> e;
        Properties tp;
        Properties properties = this.tableModel.getProperties();
        for (Point point : this.propertiesCoordinates) {
            tp = this.getPropertiesAt(point);
            if (tp == null) continue;
            e = this.mergedProperties.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                val = (String)properties.get(key);
                if ("?".equals(val)) continue;
                tp.remove(key);
            }
        }
        for (Point point : this.propertiesCoordinates) {
            tp = this.getPropertiesAt(point);
            if (tp == null) {
                tp = new Properties();
                this.setPropertiesAt(point, tp);
            }
            e = properties.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                val = properties.getProperty(key);
                if ("?".equals(val)) continue;
                tp.setProperty(key, val);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.applyPropertiesToTiles();
    }
}

